/*
 * Decompiled with CFR 0.152.
 */
package com.penfieldrobotics.criotools;

import org.eclipse.cdt.managedbuilder.core.IManagedProject;
import org.eclipse.cdt.managedbuilder.envvar.IBuildEnvironmentVariable;
import org.eclipse.cdt.managedbuilder.envvar.IEnvironmentVariableProvider;
import org.eclipse.cdt.managedbuilder.envvar.IProjectEnvironmentVariableSupplier;

public class EnvironmentVariableSupplier
implements IProjectEnvironmentVariableSupplier {
    public static String getWindBase() {
        String s = System.getenv("PROGRAMFILES(x86)");
        if (s == null || s.length() == 0) {
            s = System.getenv("PROGRAMFILES");
        }
        return String.valueOf(s) + "\\FRC_Toolchain\\mingw\\powerpc-wrs-vxworks\\wind_base\\";
    }

    private IBuildEnvironmentVariable getWindBaseEnvVar() {
        return new EnvVar("WIND_BASE", EnvironmentVariableSupplier.getWindBase(), 1);
    }

    public IBuildEnvironmentVariable getVariable(String variableName, IManagedProject project, IEnvironmentVariableProvider provider) {
        if (variableName == "WIND_BASE") {
            return this.getWindBaseEnvVar();
        }
        return null;
    }

    public IBuildEnvironmentVariable[] getVariables(IManagedProject project, IEnvironmentVariableProvider provider) {
        return new IBuildEnvironmentVariable[]{this.getWindBaseEnvVar()};
    }

    private static class EnvVar
    implements IBuildEnvironmentVariable {
        String name;
        String val;
        int type;

        public EnvVar(String name, String val, int type) {
            this.name = name;
            this.val = val;
            this.type = type;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.val;
        }

        public int getOperation() {
            return this.type;
        }

        public String getDelimiter() {
            return ";";
        }
    }
}

