/*
 * Decompiled with CFR 0.152.
 */
package com.penfieldrobotics.criotools.launch;

import com.penfieldrobotics.criotools.ThunderCRIOTools;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.internal.core.cdtvariables.CdtVariableManager;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PlatformUI;

public class LaunchShortcut
implements ILaunchShortcut {
    public void launch(ISelection selection, String mode) {
        IStructuredSelection ssel = (IStructuredSelection)selection;
        if (!(ssel.getFirstElement() instanceof IProject)) {
            return;
        }
        IProject proj = (IProject)ssel.getFirstElement();
        this.doLaunch(proj, mode);
    }

    public void launch(IEditorPart editor, String mode) {
        if (editor == null) {
            return;
        }
        IFileEditorInput ei = (IFileEditorInput)editor.getEditorInput();
        IFile f = ei.getFile();
        IProject proj = f.getProject();
        this.doLaunch(proj, mode);
    }

    private String getTeamIP() {
        int teamNum = ThunderCRIOTools.getDefault().getPreferenceStore().getInt("");
        if (teamNum <= 0 || teamNum >= 10000) {
            MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Invalid Team Number", (String)(teamNum == 0 ? "You must configure your team number in Window->Preferences->Thunder cRIO Tools before you can deploy code" : "The team number you have set is invalid - please set a valid team number in Window->Preferences->Thunder cRIO Tools"));
            return null;
        }
        return "10." + String.valueOf(teamNum / 100) + "." + String.valueOf(teamNum % 100) + ".2";
    }

    private void doLaunch(IProject proj, String mode) {
        File file;
        IManagedBuildInfo mbi = ManagedBuildManager.getBuildInfo((IResource)proj);
        ManagedBuildManager.getBuildMacroProvider();
        CoreModel.getDefault().getCModel().getCProject(proj.getName());
        ICConfigurationDescription cfg = ManagedBuildManager.getDescriptionForConfiguration((IConfiguration)mbi.getDefaultConfiguration());
        try {
            String filePath = CdtVariableManager.getDefault().resolveValue("${ProjDirPath}/${ConfigName}/${BuildArtifactFileName}.out", null, null, cfg);
            file = new File(filePath);
        }
        catch (Exception e) {
            ErrorDialog.openError(null, (String)"Cannot get binary file location", (String)"An unknown error occurred getting the file location.", (IStatus)new Status(4, "com.penfieldrobotics.criotools", 1, "", (Throwable)e));
            return;
        }
        String ip = this.getTeamIP();
        if (ip == null) {
            return;
        }
        LaunchJob job = new LaunchJob(proj, file, ip);
        job.setPriority(30);
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent ev) {
                final IStatus status = ev.getResult();
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!status.isOK()) {
                            status.getException().printStackTrace();
                            MessageDialog.openError(null, (String)"Deply Error", (String)status.getMessage());
                        } else {
                            MessageDialog.openInformation(null, (String)"Deploy Successful!", (String)"Program successfully deployed to cRIO.  You must reboot the cRIO to begin running the new program!");
                        }
                    }
                });
            }
        });
        job.setUser(true);
        job.schedule();
    }

    private static class LaunchJob
    extends Job {
        private IProject proj;
        private File file;
        private String ip;
        private String error;
        private Exception ex;

        public LaunchJob(IProject proj, File file, String ip) {
            super("Thunder cRIO Tools Launch Job " + file.getName());
            this.proj = proj;
            this.file = file;
            this.ip = ip;
        }

        public String getErrorText() {
            return this.error;
        }

        public Exception getErrorCause() {
            return this.ex;
        }

        protected IStatus run(IProgressMonitor monitor) {
            OutputStream outStream;
            URL url;
            FileInputStream fis;
            try {
                this.proj.build(10, (IProgressMonitor)new SubProgressMonitor(monitor, 5));
            }
            catch (Exception e) {
                e.printStackTrace();
                this.error = "Errors building your project - please correct them and try again.";
                this.ex = e;
                return new Status(8, "com.penfieldrobotics.criotools", this.error, (Throwable)this.ex);
            }
            try {
                fis = new FileInputStream(this.file);
            }
            catch (FileNotFoundException e) {
                this.error = "Binary file " + this.file.getName() + " not found - does your project have errors in the build?";
                this.ex = e;
                return new Status(8, "com.penfieldrobotics.criotools", this.error, (Throwable)this.ex);
            }
            try {
                url = new URL("ftp://" + this.ip + "/ni-rt/system/FRC_UserProgram.out;type=i");
            }
            catch (MalformedURLException e) {
                this.ex = e;
                this.error = "Unknown error occurred constructing FTP URL to cRIO?";
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
                return Status.CANCEL_STATUS;
            }
            monitor.beginTask("Connecting to cRIO...", 100);
            try {
                URLConnection conn = url.openConnection();
                outStream = conn.getOutputStream();
            }
            catch (IOException e) {
                this.error = "Unable to connect to cRIO at " + this.ip + ".  Check your team number setting in Preferences and verify your network setup is correct.";
                this.ex = e;
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
                return new Status(8, "com.penfieldrobotics.criotools", this.error, (Throwable)this.ex);
            }
            monitor.setTaskName("Uploading binary...");
            monitor.worked(5);
            try {
                try {
                    int n;
                    byte[] buf = new byte[1024];
                    long total = 0L;
                    long flen = this.file.length();
                    int lastPct = 0;
                    while ((n = fis.read(buf)) != -1) {
                        outStream.write(buf, 0, n);
                        int newPct = (int)((total += (long)n) * 90L / flen);
                        int dp = newPct - lastPct;
                        if (dp > 0) {
                            monitor.worked(dp);
                        }
                        lastPct = newPct;
                    }
                    monitor.done();
                }
                catch (IOException e) {
                    this.error = "Error while transferring file to cRIO. Partially uploaded file may be corrupt - fix network issues then redeploy code!";
                    this.ex = e;
                    Status status = new Status(8, "com.penfieldrobotics.criotools", this.error, (Throwable)this.ex);
                    try {
                        fis.close();
                        outStream.close();
                    }
                    catch (IOException iOException) {}
                    return status;
                }
            }
            catch (Throwable throwable) {
                try {
                    fis.close();
                    outStream.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                fis.close();
                outStream.close();
            }
            catch (IOException iOException) {}
            return Status.OK_STATUS;
        }
    }
}

